<?php $__env->startSection('content'); ?>
    <div class="widget meta-boxes">
        <div class="widget-title">
            <h4>&nbsp; <?php echo e(trans('plugins/translation::translation.translations')); ?></h4>
        </div>
        <div class="widget-body box-translation">
            <?php if(empty($group)): ?>
                <?php echo Form::open(['route' => 'translations.import', 'class' => 'form-inline', 'role' => 'form']); ?>

                    <div class="ui-select-wrapper d-inline-block">
                        <select name="replace" class="form-control ui-select">
                            <option value="0"><?php echo e(trans('plugins/translation::translation.append_translation')); ?></option>
                            <option value="1"><?php echo e(trans('plugins/translation::translation.replace_translation')); ?></option>
                        </select>
                        <svg class="svg-next-icon svg-next-icon-size-16">
                            <use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#select-chevron"></use>
                        </svg>
                    </div>
                    <button type="submit" class="btn btn-primary button-import-groups"><?php echo e(trans('plugins/translation::translation.import_group')); ?></button>
                <?php echo Form::close(); ?>

                <br>
            <?php endif; ?>
            <?php if(!empty($group)): ?>
                <form method="POST" action="<?php echo e(route('translations.group.publish', compact('group'))); ?>" class="form-inline" role="form">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-info button-publish-groups"><?php echo e(trans('plugins/translation::translation.publish_translations')); ?></button>
                    <a href="<?php echo e(route('translations.index')); ?>" class="btn btn-secondary translation-back"><?php echo e(trans('plugins/translation::translation.back')); ?></a>
                </form>
                <p class="text-info"><?php echo e(trans('plugins/translation::translation.export_warning', ['lang_path' => lang_path()])); ?></p>
            <?php endif; ?>
            <?php echo Form::open(['role' => 'form']); ?>

                <div class="ui-select-wrapper">
                    <select name="group" id="group" class="form-control ui-select group-select select-search-full">
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"<?php echo e($key == $group ? ' selected' : ''); ?>><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <svg class="svg-next-icon svg-next-icon-size-16">
                        <use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#select-chevron"></use>
                    </svg>
                </div>
                <br>
            <?php echo Form::close(); ?>

            <?php if(!empty($group)): ?>
                <hr>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($locale); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $translations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $translation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="<?php echo e($key); ?>">
                                <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $item = isset($translation[$locale]) ? $translation[$locale] : null ?>
                                    <td class="text-start">
                                        <a href="#edit" class="editable status-<?php echo e($item ? $item->status : 0); ?> locale-<?php echo e($locale); ?>"
                                           data-locale="<?php echo e($locale); ?>" data-name="<?php echo e($locale . '|' . $key); ?>"
                                           data-type="textarea" data-pk="<?php echo e($item ? $item->id : 0); ?>" data-url="<?php echo e($editUrl); ?>"
                                           data-title="<?php echo e(trans('plugins/translation::translation.edit_title')); ?>"><?php echo ($item ? htmlentities($item->value, ENT_QUOTES, 'UTF-8', false) : ''); ?></a>
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-info"><?php echo e(trans('plugins/translation::translation.choose_group_msg')); ?></p>
            <?php endif; ?>
        </div>
        <div class="clearfix"></div>
    </div>
    <?php if(!empty($group)): ?>
        <?php echo Form::modalAction('confirm-publish-modal', trans('plugins/translation::translation.publish_translations'), 'warning', trans('plugins/translation::translation.confirm_publish_group', ['group' => $group]), 'button-confirm-publish-groups', trans('core/base::base.yes')); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(BaseHelper::getAdminMasterLayoutTemplate(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/baronmac/shop.baronmachinesint.one/platform/plugins/translation//resources/views//index.blade.php ENDPATH**/ ?>