<?php $payPalStatus = setting('payment_paypal_status'); ?>
<table class="table payment-method-item">
    <tbody>
    <tr class="border-pay-row">
        <td class="border-pay-col"><i class="fa fa-theme-payments"></i></td>
        <td style="width: 20%;">
            <img class="filter-black" src="<?php echo e(url('vendor/core/plugins/paypal/images/paypal.svg')); ?>" alt="PayPal">
        </td>
        <td class="border-right">
            <ul>
                <li>
                    <a href="https://paypal.com" target="_blank">PayPal</a>
                    <p><?php echo e(trans('plugins/payment::payment.paypal_description')); ?></p>
                </li>
            </ul>
        </td>
    </tr>
    <tr class="bg-white">
        <td colspan="3">
            <div class="float-start" style="margin-top: 5px;">
                <div class="payment-name-label-group  <?php if($payPalStatus== 0): ?> hidden <?php endif; ?>">
                    <span class="payment-note v-a-t"><?php echo e(trans('plugins/payment::payment.use')); ?>:</span> <label class="ws-nm inline-display method-name-label"><?php echo e(setting('payment_paypal_name')); ?></label>
                </div>
            </div>
            <div class="float-end">
                <a class="btn btn-secondary toggle-payment-item edit-payment-item-btn-trigger <?php if($payPalStatus == 0): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.edit')); ?></a>
                <a class="btn btn-secondary toggle-payment-item save-payment-item-btn-trigger <?php if($payPalStatus == 1): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.settings')); ?></a>
            </div>
        </td>
    </tr>
    <tr class="paypal-online-payment payment-content-item hidden">
        <td class="border-left" colspan="3">
            <?php echo Form::open(); ?>

            <?php echo Form::hidden('type', PAYPAL_PAYMENT_METHOD_NAME, ['class' => 'payment_type']); ?>

            <div class="row">
                <div class="col-sm-6">
                    <ul>
                        <li>
                            <label><?php echo e(trans('plugins/payment::payment.configuration_instruction', ['name' => 'PayPal'])); ?></label>
                        </li>
                        <li class="payment-note">
                            <p><?php echo e(trans('plugins/payment::payment.configuration_requirement', ['name' => 'PayPal'])); ?>:</p>
                            <ul class="m-md-l" style="list-style-type:decimal">
                                <li style="list-style-type:decimal">
                                    <a href="https://www.paypal.com/vn/merchantsignup/applicationChecklist?signupType=CREATE_NEW_ACCOUNT&amp;productIntentId=email_payments" target="_blank">
                                        <?php echo e(trans('plugins/payment::payment.service_registration', ['name' => 'PayPal'])); ?>

                                    </a>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(trans('plugins/payment::payment.after_service_registration_msg', ['name' => 'PayPal'])); ?></p>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(trans('plugins/payment::payment.enter_client_id_and_secret')); ?></p>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-6">
                    <div class="well bg-white">
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="paypal_name"><?php echo e(trans('plugins/payment::payment.method_name')); ?></label>
                            <input type="text" class="next-input input-name" name="payment_paypal_name" id="paypal_name" data-counter="400" value="<?php echo e(setting('payment_paypal_name', trans('plugins/payment::payment.pay_online_via', ['name' => 'PayPal']))); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="payment_paypal_description"><?php echo e(trans('core/base::forms.description')); ?></label>
                            <textarea class="next-input" name="payment_paypal_description" id="payment_paypal_description"><?php echo e(get_payment_setting('description', 'paypal', __('You will be redirected to PayPal to complete the payment.'))); ?></textarea>
                        </div>
                        <p class="payment-note">
                            <?php echo e(trans('plugins/payment::payment.please_provide_information')); ?> <a target="_blank" href="//www.paypal.com">PayPal</a>:
                        </p>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="paypal_client_id"><?php echo e(trans('plugins/payment::payment.client_id')); ?></label>
                            <input type="text" class="next-input" name="payment_paypal_client_id" id="paypal_client_id" value="<?php echo e(app()->environment('demo') ? '*******************************' :setting('payment_paypal_client_id')); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="paypal_client_secret"><?php echo e(trans('plugins/payment::payment.client_secret')); ?></label>
                            <div class="input-option">
                                <input type="password" class="next-input" placeholder="••••••••" id="paypal_client_secret" name="payment_paypal_client_secret" value="<?php echo e(app()->environment('demo') ? '*******************************' : setting('payment_paypal_client_secret')); ?>">
                            </div>
                        </div>
                        <?php echo Form::hidden('payment_paypal_mode', 1); ?>

                        <div class="form-group mb-3">
                            <label class="next-label">
                                <input type="checkbox"  value="0" name="payment_paypal_mode" <?php if(setting('payment_paypal_mode') == 0): ?> checked <?php endif; ?>>
                                <?php echo e(trans('plugins/payment::payment.sandbox_mode')); ?>

                            </label>
                        </div>

                        <?php echo apply_filters(PAYMENT_METHOD_SETTINGS_CONTENT, null, 'paypal'); ?>

                    </div>
                </div>
            </div>
            <div class="col-12 bg-white text-end">
                <button class="btn btn-warning disable-payment-item <?php if($payPalStatus == 0): ?> hidden <?php endif; ?>" type="button"><?php echo e(trans('plugins/payment::payment.deactivate')); ?></button>
                <button class="btn btn-info save-payment-item btn-text-trigger-save <?php if($payPalStatus == 1): ?> hidden <?php endif; ?>" type="button"><?php echo e(trans('plugins/payment::payment.activate')); ?></button>
                <button class="btn btn-info save-payment-item btn-text-trigger-update <?php if($payPalStatus == 0): ?> hidden <?php endif; ?>" type="button"><?php echo e(trans('plugins/payment::payment.update')); ?></button>
            </div>
            <?php echo Form::close(); ?>

        </td>
    </tr>
    </tbody>
</table>
<?php /**PATH /home/baronmac/public_html/platform/plugins/paypal//resources/views//settings.blade.php ENDPATH**/ ?>