<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('template_title', trans('packages/installer::installer.title')); ?></title>

    <link rel="icon" href="<?php echo e(asset('vendor/core/core/base/images/favicon.png')); ?>">
    <link href="<?php echo e(asset('vendor/core/core/base/libraries/font-awesome/css/fontawesome.min.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('vendor/core/packages/installer/css/style.css')); ?>" rel="stylesheet"/>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="//fonts.googleapis.com/css?family=Lato:400,700%7cPoppins:200,400,500,700" rel="stylesheet">

    <?php echo $__env->yieldContent('style'); ?>
</head>
<body>
    <div class="master">
        <div class="box">
            <div class="header">
                <h1 class="header__title"><?php echo $__env->yieldContent('title'); ?></h1>
            </div>
            <ul class="step">
                <li class="step__divider"></li>
                <li class="step__item <?php echo e(get_active_menu_class_name('installers.final')); ?>">
                    <i class="step__icon fa fa-server" aria-hidden="true"></i>
                </li>
                <li class="step__divider"></li>
                <li class="step__item <?php echo e(get_active_menu_class_name('installers.environment')); ?>">
                    <?php if(Request::is('install/environment') || Request::is('install/environment') || Request::is('install/environment/save') ): ?>
                        <a href="<?php echo e(URL::signedRoute('installers.environment', [], \Carbon\Carbon::now()->addMinutes(30))); ?>">
                            <i class="step__icon fa fa-cog" aria-hidden="true"></i>
                        </a>
                    <?php else: ?>
                        <i class="step__icon fa fa-cog" aria-hidden="true"></i>
                    <?php endif; ?>
                </li>
                <li class="step__divider"></li>
                <li class="step__divider"></li>
                <li class="step__item <?php echo e(get_active_menu_class_name('installers.requirements')); ?>">
                    <?php if(Request::is('install') || Request::is('install/requirements') || Request::is('install/environment') || Request::is('install/environment/save') ): ?>
                        <a href="<?php echo e(URL::signedRoute('installers.requirements', [], \Carbon\Carbon::now()->addMinutes(30))); ?>">
                            <i class="step__icon fa fa-list" aria-hidden="true"></i>
                        </a>
                    <?php else: ?>
                        <i class="step__icon fa fa-list" aria-hidden="true"></i>
                    <?php endif; ?>
                </li>
                <li class="step__divider"></li>
                <li class="step__item <?php echo e(get_active_menu_class_name('installers.welcome')); ?>">
                    <?php if(Request::is('install') || Request::is('install/requirements') || Request::is('install/environment') || Request::is('install/environment/save') ): ?>
                        <a href="<?php echo e(URL::signedRoute('installers.welcome', [], \Carbon\Carbon::now()->addMinutes(30))); ?>">
                            <i class="step__icon fa fa-home" aria-hidden="true"></i>
                        </a>
                    <?php else: ?>
                        <i class="step__icon fa fa-home" aria-hidden="true"></i>
                    <?php endif; ?>
                </li>
                <li class="step__divider"></li>
            </ul>
            <div class="main">
                <?php if(session('message')): ?>
                    <p class="alert text-center">
                        <strong>
                            <?php if(is_array(session('message'))): ?>
                                <?php echo e(session('message')['message']); ?>

                            <?php else: ?>
                                <?php echo e(session('message')); ?>

                            <?php endif; ?>
                        </strong>
                    </p>
                <?php endif; ?>
                <?php if(session()->has('errors')): ?>
                    <div class="alert alert-danger" id="error_alert">
                        <button type="button" class="close" id="close_alert" data-dismiss="alert" aria-hidden="true">
                            <i class="fa fa-close" aria-hidden="true"></i>
                        </button>
                        <h4>
                            <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                            <?php echo e(trans('packages/installer::installer.forms.errorTitle')); ?>

                        </h4>
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php echo $__env->yieldContent('container'); ?>
            </div>
        </div>
    </div>
    <script src="<?php echo e(asset('vendor/core/packages/installer/js/script.js')); ?>"></script>

    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/baronmac/public_html/platform/packages/installer//resources/views//master.blade.php ENDPATH**/ ?>