<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?php echo e(trans('plugins/ecommerce::order.invoice_for_order')); ?> <?php echo e($invoice->code); ?></title>

    <?php if(get_ecommerce_setting('using_custom_font_for_invoice', 0) == 1 && get_ecommerce_setting('invoice_font_family')): ?>
        <link href="https://fonts.googleapis.com/css?family=<?php echo e(urlencode(get_ecommerce_setting('invoice_font_family'))); ?>:400,500,600,700,900&display=swap" rel="stylesheet">
    <?php endif; ?>
    <style>
        body {
            font-size: 15px;
            font-family: '<?php echo e(get_ecommerce_setting('using_custom_font_for_invoice', 0) == 1 ? get_ecommerce_setting('invoice_font_family', 'DejaVu Sans') : 'DejaVu Sans'); ?>', Arial, sans-serif !important;
        }

        table {
            border-collapse : collapse;
            width           : 100%
        }

        table tr td {
            padding : 0
        }

        table tr td:last-child {
            text-align : right
        }

        .bold, strong {
            font-weight : 700
        }

        .right {
            text-align : right
        }

        .large {
            font-size : 1.75em
        }

        .total {
            color       : #fb7578;
            font-weight : 700
        }

        .logo-container {
            margin : 20px 0 50px
        }

        .invoice-info-container {
            font-size : .875em
        }

        .invoice-info-container td {
            padding : 4px 0
        }

        .line-items-container {
            font-size : .875em;
            margin    : 70px 0
        }

        .line-items-container th {
            border-bottom  : 2px solid #ddd;
            color          : #999;
            font-size      : .75em;
            padding        : 10px 0 15px;
            text-align     : left;
            text-transform : uppercase
        }

        .line-items-container th:last-child {
            text-align : right
        }

        .line-items-container td {
            padding : 10px 0
        }

        .line-items-container tbody tr:first-child td {
            padding-top : 25px
        }

        .line-items-container.has-bottom-border tbody tr:last-child td {
            border-bottom  : 2px solid #ddd;
            padding-bottom : 25px
        }

        .line-items-container th.heading-quantity {
            width : 50px
        }

        .line-items-container th.heading-price {
            text-align : right;
            width      : 100px
        }

        .line-items-container th.heading-subtotal {
            width : 100px
        }

        .payment-info {
            font-size   : .875em;
            line-height : 1.5;
            width       : 38%
        }

        small {
            font-size : 80%
        }

        .stamp {
            border         : 2px solid #555;
            color          : #555;
            display        : inline-block;
            font-size      : 18px;
            font-weight    : 700;
            left           : 30%;
            line-height    : 1;
            opacity        : .5;
            padding        : .3rem .75rem;
            position       : fixed;
            text-transform : uppercase;
            top            : 40%;
            transform      : rotate(-14deg)
        }

        .is-failed {
            border-color : #d23;
            color        : #d23
        }

        .is-completed {
            border-color : #0a9928;
            color        : #0a9928
        }
    </style>
</head>
<body>

<?php if(get_ecommerce_setting('enable_invoice_stamp', 1) == 1): ?>
    <?php if($invoice->status == \Botble\Ecommerce\Enums\OrderStatusEnum::CANCELED && trim($invoice->status->label())): ?>
        <span class="stamp is-failed">
            <?php echo e($invoice->status->label()); ?>

        </span>

    <?php elseif(trim($invoice->payment->status->label())): ?>
        <span class="stamp <?php if($invoice->payment->status == \Botble\Payment\Enums\PaymentStatusEnum::COMPLETED): ?> is-completed <?php else: ?> is-failed <?php endif; ?>">
            <?php echo e($invoice->payment->status->label()); ?>

        </span>
    <?php endif; ?>
<?php endif; ?>

<?php
    $logo = get_ecommerce_setting('company_logo_for_invoicing') ?: (theme_option('logo_in_invoices') ?: theme_option('logo'));
?>

<table class="invoice-info-container">
    <tr>
        <td>
            <div class="logo-container">
                <?php if($logo): ?>
                    <img src="<?php echo e(RvMedia::getRealPath($logo)); ?>"
                         style="width:100%; max-width:150px;" alt="<?php echo e(get_ecommerce_setting('company_name_for_invoicing') ?: theme_option('site_title')); ?>">
                <?php endif; ?>
            </div>
        </td>
        <td>
            <?php if($invoice->created_at): ?>
                <p><strong><?php echo e($invoice->created_at->format('F d, Y')); ?></strong></p>
            <?php endif; ?>
            <p><strong><?php echo e(trans('plugins/ecommerce::order.invoice')); ?></strong> <?php echo e($invoice->code); ?></p>
        </td>
    </tr>
</table>

<table class="invoice-info-container">
    <tr>
        <td>
            <?php if(get_ecommerce_setting('company_name_for_invoicing') || get_ecommerce_setting('store_name')): ?>
                <p><?php echo e(get_ecommerce_setting('company_name_for_invoicing') ?: get_ecommerce_setting('store_name')); ?></p>
            <?php endif; ?>

            <?php if(get_ecommerce_setting('company_address_for_invoicing')): ?>
                <p><?php echo e(get_ecommerce_setting('company_address_for_invoicing')); ?></p>
            <?php else: ?>
                <p><?php echo e(get_ecommerce_setting('store_address')); ?>, <?php echo e(get_ecommerce_setting('store_city')); ?>, <?php echo e(get_ecommerce_setting('store_state')); ?>, <?php echo e(EcommerceHelper::getCountryNameById(get_ecommerce_setting('store_country'))); ?></p>
            <?php endif; ?>
            <?php if(get_ecommerce_setting('company_phone_for_invoicing') || get_ecommerce_setting('store_phone')): ?>
                <p><?php echo e(get_ecommerce_setting('company_phone_for_invoicing') ?: get_ecommerce_setting('store_phone')); ?></p>
            <?php endif; ?>
            <?php if(get_ecommerce_setting('company_email_for_invoicing') || get_ecommerce_setting('store_email')): ?>
                <p><?php echo e(get_ecommerce_setting('company_email_for_invoicing') ?: get_ecommerce_setting('store_email')); ?></p>
            <?php endif; ?>

            <?php if(get_ecommerce_setting('company_tax_id_for_invoicing') || get_ecommerce_setting('store_vat_number')): ?>
                <p><?php echo e(trans('plugins/ecommerce::ecommerce.setting.vat_number')); ?>: <?php echo e(get_ecommerce_setting('company_tax_id_for_invoicing') ?: get_ecommerce_setting('store_vat_number')); ?></p>
            <?php endif; ?>
        </td>
        <td>
            <?php if($invoice->customer_name): ?>
                <p><?php echo e($invoice->customer_name); ?></p>
            <?php endif; ?>
            <?php if($invoice->customer_address ): ?>
                <p><?php echo e($invoice->customer_address); ?></p>
            <?php endif; ?>

            <?php if($invoice->customer_phone): ?>
                <p><?php echo e($invoice->customer_phone); ?></p>
            <?php endif; ?>
        </td>
    </tr>
</table>

<?php if($invoice->description): ?>
    <table class="invoice-info-container">
        <tr style="text-align: left">
            <td style="text-align: left">
                <p><?php echo e(trans('plugins/ecommerce::order.note')); ?>: <?php echo e($invoice->description); ?></p>
            </td>
        </tr>
    </table>
<?php endif; ?>

<table class="line-items-container">
    <thead>
    <tr>
        <th class="heading-description"><?php echo e(trans('plugins/ecommerce::products.form.product')); ?></th>
        <th class="heading-description"><?php echo e(trans('plugins/ecommerce::products.form.options')); ?></th>
        <th class="heading-quantity"><?php echo e(trans('plugins/ecommerce::products.form.quantity')); ?></th>
        <th class="heading-price"><?php echo e(trans('plugins/ecommerce::products.form.price')); ?></th>
        <th class="heading-subtotal"><?php echo e(trans('plugins/ecommerce::products.form.total')); ?></th>
    </tr>
    </thead>
    <tbody>

        <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoiceItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $product = get_products([
                    'condition' => [
                        'ec_products.id' => $invoiceItem->reference_id,
                    ],
                    'take'   => 1,
                    'select' => [
                        'ec_products.id',
                        'ec_products.images',
                        'ec_products.name',
                        'ec_products.price',
                        'ec_products.sale_price',
                        'ec_products.sale_type',
                        'ec_products.start_date',
                        'ec_products.end_date',
                        'ec_products.sku',
                        'ec_products.is_variation',
                        'ec_products.status',
                        'ec_products.order',
                        'ec_products.created_at',
                    ],
                ]);
            ?>
            <?php if(!empty($product)): ?>
                <tr>
                    <td>
                        <?php echo e($product->original_product->name ?: $invoiceItem->name); ?>

                    </td>
                    <td>
                        <small><?php echo e($product->variation_attributes); ?></small>

                        <?php if(!empty($invoiceItem->options) && is_array($invoiceItem->options)): ?>
                            <?php $__currentLoopData = $invoiceItem->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!empty($option['key']) && !empty($option['value'])): ?>
                                    <p class="mb-0">
                                        <small><?php echo e($option['key']); ?>:
                                            <strong> <?php echo e($option['value']); ?></strong></small>
                                    </p>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php echo e($invoiceItem->qty); ?>

                    </td>
                    <td class="right">
                        <?php echo htmlentities(format_price($invoiceItem->sub_total)); ?>

                    </td>
                    <td class="bold">
                        <?php echo htmlentities(format_price($invoiceItem->amount)); ?>

                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <tr>
            <td colspan="4" class="right">
                <?php echo e(trans('plugins/ecommerce::products.form.sub_total')); ?>

            </td>
            <td class="bold">
                <?php echo htmlentities(format_price($invoice->sub_total)); ?>

            </td>
        </tr>
        <?php if(EcommerceHelper::isTaxEnabled()): ?>
            <tr>
                <td colspan="4" class="right">
                    <?php echo e(trans('plugins/ecommerce::products.form.tax')); ?>

                </td>
                <td class="bold">
                    <?php echo htmlentities(format_price($invoice->tax_amount)); ?>

                </td>
            </tr>
        <?php endif; ?>
        <tr>
            <td colspan="4" class="right">
                <?php echo e(trans('plugins/ecommerce::products.form.shipping_fee')); ?>

            </td>
            <td class="bold">
                <?php echo htmlentities(format_price($invoice->shipping_amount)); ?>

            </td>
        </tr>
        <tr>
            <td colspan="4" class="right">
                <?php echo e(trans('plugins/ecommerce::products.form.discount')); ?>

            </td>
            <td class="bold">
                <?php echo htmlentities(format_price($invoice->discount_amount)); ?>

            </td>
        </tr>
    </tbody>
</table>

<table class="line-items-container">
    <thead>
        <tr>
            <th><?php echo e(trans('plugins/ecommerce::order.payment_info')); ?></th>
            <th><?php echo e(trans('plugins/ecommerce::order.total_amount')); ?></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="payment-info">

                <?php if($invoice->payment->payment_channel->label()): ?>
                    <div>
                        <?php echo e(trans('plugins/ecommerce::order.payment_method')); ?>: <strong><?php echo e($invoice->payment->payment_channel->label()); ?></strong>
                    </div>
                <?php endif; ?>

                <?php if($invoice->payment->status->label()): ?>
                    <div>
                        <?php echo e(trans('plugins/ecommerce::order.payment_status_label')); ?>: <strong><?php echo e($invoice->payment->status->label()); ?></strong>
                    </div>
                <?php endif; ?>

                <?php if($invoice->payment->payment_channel == \Botble\Payment\Enums\PaymentMethodEnum::BANK_TRANSFER && $invoice->payment->status == \Botble\Payment\Enums\PaymentStatusEnum::PENDING): ?>
                    <div>
                        <?php echo e(trans('plugins/ecommerce::order.payment_info')); ?>: <strong><?php echo BaseHelper::clean(get_payment_setting('description', $invoice->payment->payment_channel)); ?></strong>
                    </div>
                <?php endif; ?>
            </td>
            <td class="large total"><?php echo htmlentities(format_price($invoice->amount)); ?></td>
        </tr>
    </tbody>
</table>
</body>
</html>
<?php /**PATH /home2/baronmachinesint/public_html/shop/platform/plugins/ecommerce//resources/views//invoices/template.blade.php ENDPATH**/ ?>